ORCA/M Asm65816 2.1.0

0001 EF26                       TITLE ', FILES.a - Next_Header'
0002 EF26              *
0003 EF26              ****************************************************************
0004 EF26              *
0005 EF26              *              Read Next Segment Header
0006 EF26              *
0007 EF26              *  Inputs:     Header_Mark - Segment Header File Mark
0008 EF26              *
0009 EF26              *  Outputs:    A - status
0010 EF26              *              C - set if error occurred
0011 EF26              *              Header - contains Segment Header
0012 EF26              *              Header_Mark - File Mark of next Segment Header
0013 EF26              *
0014 EF26              *  Zero Page used: TempZero
0015 EF26              *
0016 EF26              ****************************************************************
0017 EF26              *
0018 EF26              Next_Header PROC 
0019 EF26                       with DirectPage, Globals
0020 EF26              ;
0021 EF26              ;        is Header_Mark in current File Buffer ?
0022 EF26              ;
0023 EF26 AD 22 A7              lda   |Header_Mark
0024 EF29 38                    sec   
0025 EF2A ED 1E A7              sbc   |File_Mark
0026 EF2D 85 00                 sta   TempZero
0027 EF2F AD 24 A7              lda   |Header_Mark+2
0028 EF32 ED 20 A7              sbc   |File_Mark+2
0029 EF35 85 02                 sta   TempZero+2
0030 EF37 D0 0C                 bne   cont1
0031 EF39 A5 00                 lda   TempZero
0032 EF3B CD 1C A7              cmp   |File_EOB
0033 EF3E B0 05                 bcs   cont1
0034 EF40              ;
0035 EF40              ;        yes, set File_Pt to location of Header_Mark
0036 EF40              ;
0037 EF40 8D 1A A7              sta   |File_Pt
0038 EF43 80 27                 bra   cont2
0039 EF45              ;
0040 EF45              ;        no, is this is a Memory Load
0041 EF45              ;
0042 EF45 A5 38        cont1    lda   Memory_Load
0043 EF47 F0 06                 beq   cont1a
0044 EF49              ;
0045 EF49              ;        yes, set EOF condition and exit
0046 EF49              ;
0047 EF49 A9 4C 00              lda   #eofEncountered
0048 EF4C              error_skip  
0049 EF4C 4C C1 EF              jmp   error
0050 EF4F              ;
0051 EF4F              ;        no, set Mark of file to Header_Mark
0052 EF4F              ;
0053 EF4F AD 22 A7     cont1a   lda   |Header_Mark
0054 EF52 8D 62 A7              sta   |PSetMark.position
0055 EF55 AD 24 A7              lda   |Header_Mark+2
0056 EF58 8D 64 A7              sta   |PSetMark.position+2
0057 EF5B
0058 EF5B 22 A8 00 E1           jsl   $E100A8                  ;call GS/OS
0059 EF5F 16 00                 DC W:SET_MARK
0060 EF61 60 A7 01 00           DC L:PSetMark
0061 EF65 B0 E5                 bcs   error_skip
0062 EF67              ;
0063 EF67              ;        fill File Buffer
0064 EF67              ;
0065 EF67 20 3C F3              jsr   Fill_File_Buff
0066 EF6A B0 E0                 bcs   error_skip
0067 EF6C              ;
0068 EF6C              ;        read 1st part of Header (up to DispData) so that size of
0069 EF6C              ;        complete Header can be determined
0070 EF6C              ;
0071 EF6C F4 01 00     cont2    pea   Header>>16               ;Address
0072 EF6F F4 B8 A6              pea   |Header
0073 EF72 F4 00 00              pea   SegmentHeader.DispData+2>>16 ;Bytes
0074 EF75 F4 2C 00              pea   SegmentHeader.DispData+2
0075 EF78 20 D2 EF              jsr   Read_File
0076 EF7B A9 04 11              lda   #NotLoad                 ;error means garbage header
0077 EF7E B0 CC                 bcs   error_skip
0078 EF80              ;
0079 EF80              ;       allocate a buffer for rest of Header
0080 EF80              ;
0081 EF80 AD E2 A6              lda   Header.DispData
0082 EF83 38                    sec   
0083 EF84 E9 2C 00              sbc   #SegmentHeader.DispData+2
0084 EF87 85 00                 sta   TempZero                 ;calculate size
0085 EF89 AA                    tax   
0086 EF8A A0 00 00              ldy   #0                       ;high word of size
0087 EF8D A9 06 70              lda   #uFileBuff               ;user ID to use
0088 EF90 20 52 D0              jsr   do_alloc                 ;allocate the memory
0089 EF93 B0 B7                 bcs   error_skip
0090 EF95 8A                    txa   
0091 EF96 20 D6 FA              jsr   DeRef                    ;dereference Handle
0092 EF99 8D 00 A7              sta   |Header_Var              ;save Pointer in Globals
0093 EF9C 8C 02 A7              sty   |Header_Var+2
0094 EF9F
0095 EF9F              ;
0096 EF9F              ;        read 2nd part of Header
0097 EF9F              ;
0098 EF9F 5A           cont3    phy                            ;Address
0099 EFA0 48                    pha   
0100 EFA1 F4 00 00              pea   0
0101 EFA4 D4 00                 pei   TempZero                 ;Bytes
0102 EFA6 20 D2 EF              jsr   Read_File
0103 EFA9 A9 04 11              lda   #NotLoad                 ;error means garbage header
0104 EFAC B0 13                 bcs   error
0105 EFAE              ;
0106 EFAE              ;       change DISPNAME to the offset of SEGNAME in Header_Var (for convenience in finding
0107 EFAE              ;       the Segment Name)
0108 EFAE              ;
0109 EFAE AD E0 A6              lda   Header.DispName
0110 EFB1 38                    sec   
0111 EFB2 E9 22 00              sbc   #SegmentHeader.DispData+2-10
0112 EFB5 8D E0 A6              sta   Header.DispName
0113 EFB8              ;
0114 EFB8              ;        bump Header_Mark to next Header
0115 EFB8              ;
0116 EFB8 20 7C F4              jsr   Bump_Mark
0117 EFBB              ;
0118 EFBB              ;        check KIND fields (in case old KIND field was used)
0119 EFBB              ;
0120 EFBB 20 CE EB              jsr   Check_KIND
0121 EFBE
0122 EFBE A9 00 00     return   lda   #0
0123 EFC1 C9 4C 00     error    cmp   #eofEncountered          ;End of File encountered
0124 EFC4 F0 05                 beq   error1
0125 EFC6 C9 4D 00              cmp   #outOfRange              ;Position out of range
0126 EFC9 D0 03                 bne   error2
0127 EFCB A9 01 11     error1   lda   #NoFind                  ;either error is a No Find error
0128 EFCE C9 01 00     error2   cmp   #1
0129 EFD1 60                    rts   
0130 EFD2
0131 EFD2                       ENDP 
0132 EFD2
0133 EFD2                       TITLE ', FILES.a - Read_File'
0134 EFD2              *
0135 EFD2              ****************************************************************
0136 EFD2              *
0137 EFD2              *              Read File from File Buffer
0138 EFD2              *
0139 EFD2              *  Inputs:     Address of User Buffer (TOS+7)
0140 EFD2              *              Bytes to read          (TOS+3)
0141 EFD2              *
0142 EFD2              *  Outputs:    A - status
0143 EFD2              *              C - set if error occurred
0144 EFD2              *
0145 EFD2              *  Zero Page used: TempZero
0146 EFD2              *
0147 EFD2              *        If address is zero, file will be positioned but
0148 EFD2              *        no data will be transferred
0149 EFD2              *
0150 EFD2              ****************************************************************
0151 EFD2              *
0152 EFD2              Read_File PROC 
0153 EFD2                       with DirectPage, Globals
0154 EFD2
0155 EFD2              Address  equ   7
0156 EFD2              Bytes    equ   3
0157 EFD2              ;
0158 EFD2              ;        is Bytes<$10000 and File_Pt+Bytes<$10000 and File_Pt+Bytes<=File_EOB ?
0159 EFD2              ;
0160 EFD2 A3 05                 lda   Bytes+2,s                ;if high byte of Bytes not 0,
0161 EFD4 D0 1B                 bne   cont3                    ;  Bytes>$10000
0162 EFD6 AD 1A A7              lda   |File_Pt
0163 EFD9 18                    clc   
0164 EFDA 63 03                 adc   Bytes,s
0165 EFDC B0 13                 bcs   cont3                    ;if carry set, File_Pt+Bytes>$10000
0166 EFDE CD 1C A7              cmp   |File_EOB
0167 EFE1 F0 02                 beq   cont1
0168 EFE3 B0 0C                 bcs   cont3
0169 EFE5              ;
0170 EFE5              ;        yes, do actual read
0171 EFE5              ;
0172 EFE5 A3 03        cont1    lda   Bytes,s
0173 EFE7 48                    pha   
0174 EFE8 20 39 F0              jsr   Actual_Read
0175 EFEB 68                    pla                            ;remove bytes
0176 EFEC A9 00 00              lda   #0                       ;no errors
0177 EFEF 80 39                 bra   return                   ;done
0178 EFF1              ;
0179 EFF1              ;        no, read File_EOB-File_Pt bytes to user's buffer
0180 EFF1              ;
0181 EFF1 AD 1C A7     cont3    lda   |File_EOB
0182 EFF4 38                    sec   
0183 EFF5 ED 1A A7              sbc   |File_Pt
0184 EFF8 48                    pha   
0185 EFF9 20 39 F0              jsr   Actual_Read
0186 EFFC              ;
0187 EFFC              ;        if Address<>0, increment Address by partial Bytes
0188 EFFC              ;
0189 EFFC A3 09                 lda   Address+2,s
0190 EFFE 03 0B                 ora   Address+4,s
0191 F000 F0 0E                 beq   cont4
0192 F002 A3 01                 lda   1,s
0193 F004 18                    clc   
0194 F005 63 09                 adc   Address+2,s
0195 F007 83 09                 sta   Address+2,s
0196 F009 A3 0B                 lda   Address+4,s
0197 F00B 69 00 00              adc   #0
0198 F00E 83 0B                 sta   Address+4,s
0199 F010              ;
0200 F010              ;        decrement Bytes by partial Bytes
0201 F010              ;
0202 F010 A3 05        cont4    lda   Bytes+2,s
0203 F012 38                    sec   
0204 F013 E3 01                 sbc   1,s
0205 F015 83 05                 sta   Bytes+2,s
0206 F017 A3 07                 lda   Bytes+4,s
0207 F019 E9 00 00              sbc   #0
0208 F01C 83 07                 sta   Bytes+4,s
0209 F01E 68                    pla                            ;remove partial Bytes from stack
0210 F01F              ;
0211 F01F              ;        refill File Buffer
0212 F01F              ;
0213 F01F 20 3C F3              jsr   Fill_File_Buff
0214 F022 B0 06                 bcs   error
0215 F024              ;
0216 F024              ;        if there are still bytes to read, loop
0217 F024              ;
0218 F024 A3 03                 lda   Bytes,s
0219 F026 03 05                 ora   Bytes+2,s
0220 F028 D0 A8                 bne   Read_File
0221 F02A
0222 F02A              return    
0223 F02A A8 68 83 07  error    Stack_Cleanup 8
0224 F038 60                    rts   
0225 F039
0226 F039                       ENDP 
0227 F039
0228 F039                       TITLE ', FILES.a - Actual_Read'
0229 F039              *
0230 F039              ****************************************************************
0231 F039              *
0232 F039              *              Actual Read from File Buffer
0233 F039              *
0234 F039              *  Inputs:     Address of User Buffer (TOS+12)
0235 F039              *              Bytes to read (TOS+3)
0236 F039              *
0237 F039              *  Outputs:    none
0238 F039              *
0239 F039              *  Zero Page used: TempZero
0240 F039              *
0241 F039              *        If address is zero, file will be positioned but
0242 F039              *        no data will be transferred
0243 F039              *
0244 F039              ****************************************************************
0245 F039              *
0246 F039
0247 F039              Actual_Read PROC 
0248 F039                       with DirectPage, Globals
0249 F039
0250 F039              Address  equ   11
0251 F039              Bytes    equ   3
0252 F039              ;
0253 F039              ;        threshold at which the Block Move routine is used rather
0254 F039              ;        than the internal move loop
0255 F039              ;
0256 F039              Size_Threshold equ   64
0257 F039              ;
0258 F039              ;        if address=0, don't move any data
0259 F039              ;
0260 F039 A3 0B                 lda   Address,s
0261 F03B 03 0D                 ora   Address+2,s
0262 F03D F0 43                 beq   cont2
0263 F03F              ;
0264 F03F              ;        calculate address of next byte in File Buffer = File_Buff+File_Pt
0265 F03F              ;
0266 F03F AD 14 A7              lda   |File_Buff
0267 F042 18                    clc   
0268 F043 6D 1A A7              adc   |File_Pt
0269 F046 85 00                 sta   TempZero
0270 F048 AD 16 A7              lda   |File_Buff+2
0271 F04B 69 00 00              adc   #0
0272 F04E 85 02                 sta   TempZero+2
0273 F050              ;
0274 F050              ;        check whether Bytes to read < Size_Threshold
0275 F050              ;
0276 F050 A3 03                 lda   Bytes,s
0277 F052 C9 40 00              cmp   #Size_Threshold
0278 F055 B0 18                 bcs   cont1b
0279 F057              ;
0280 F057              ;        yes, use simple load-store loop
0281 F057              ;
0282 F057 A8                    tay   
0283 F058 A3 0B                 lda   Address,s
0284 F05A 85 04                 sta   TempZero+4
0285 F05C A3 0D                 lda   Address+2,s
0286 F05E 85 06                 sta   TempZero+6
0287 F060 E2 30                 sep   #$30
0288 F062                       longa on
0289 F062                       longi on
0290 F062 88           loop     dey   
0291 F063 30 06                 bmi   cont1a
0292 F065 B7 00                 lda   [TempZero],y
0293 F067 97 04                 sta   [TempZero+4],y
0294 F069 80 F7                 bra   loop
0295 F06B C2 30        cont1a   rep   #$30
0296 F06D                       longa on
0297 F06D                       longi on
0298 F06D 80 13                 bra   cont2
0299 F06F              ;
0300 F06F              ;        no, use Block Move
0301 F06F              ;
0302 F06F D4 02        cont1b   pei   TempZero+2               ;Source
0303 F071 D4 00                 pei   TempZero
0304 F073 A3 11                 lda   Address+6,s              ;Destination
0305 F075 48                    pha   
0306 F076 A3 11                 lda   Address+6,s
0307 F078 48                    pha   
0308 F079 F4 00 00              pea   0
0309 F07C A3 0D                 lda   Bytes+10,s               ;Count
0310 F07E 48                    pha   
0311 F07F 20 EE F9              jsr   Block_Move
0312 F082              ;
0313 F082              ;        bump File_Pt by Bytes
0314 F082              ;
0315 F082 A3 03        cont2    lda   Bytes,s
0316 F084 18                    clc   
0317 F085 6D 1A A7              adc   |File_Pt
0318 F088 8D 1A A7              sta   |File_Pt
0319 F08B
0320 F08B 60                    rts   
0321 F08C
0322 F08C                       ENDP 
0323 F08C
0324 F08C                       TITLE ', FILES.a - Read_Op'
0325 F08C              *
0326 F08C              ****************************************************************
0327 F08C              *
0328 F08C              *              Read next OP code from File Buffer
0329 F08C              *
0330 F08C              *  Inputs:     none
0331 F08C              *
0332 F08C              *  Outputs:    Record - updated with Op Code
0333 F08C              *              A - status if error
0334 F08C              *              C - set if error occurred
0335 F08C              *
0336 F08C              *  Zero Page used: none
0337 F08C              *
0338 F08C              ****************************************************************
0339 F08C              *
0340 F08C
0341 F08C              Read_Op  PROC 
0342 F08C                       with DirectPage, Globals
0343 F08C              ;
0344 F08C              ;        save File Mark corresponding to this OP code
0345 F08C              ;
0346 F08C AD 1A A7              lda   |File_Pt
0347 F08F A8                    tay                            ;save
0348 F090 18                    clc   
0349 F091 6D 1E A7              adc   |File_Mark
0350 F094 85 2C                 sta   Op_Mark
0351 F096 A9 00 00              lda   #0
0352 F099 6D 20 A7              adc   |File_Mark+2
0353 F09C 85 2E                 sta   Op_Mark+2
0354 F09E              ;
0355 F09E              ;        if File Pointer is at very end of File Buffer, use
0356 F09E              ;        Read_File routine instead
0357 F09E              ;
0358 F09E CC 1C A7              cpy   |File_EOB
0359 F0A1 D0 10                 bne   cont
0360 F0A3 F4 01 00              pea   Record>>16
0361 F0A6 F4 04 A7              pea   |Record
0362 F0A9 F4 00 00              pea   0
0363 F0AC F4 01 00              pea   1
0364 F0AF 20 D2 EF              jsr   Read_File
0365 F0B2 60                    rts   
0366 F0B3              ;
0367 F0B3              ;        move 1 byte into Record
0368 F0B3              ;
0369 F0B3 B7 28        cont     lda   [FileBuff],y
0370 F0B5 8D 04 A7              sta   |Record
0371 F0B8              ;
0372 F0B8              ;        bump File_Pt
0373 F0B8              ;
0374 F0B8 EE 1A A7              inc   |File_Pt
0375 F0BB
0376 F0BB 60                    rts   
0377 F0BC
0378 F0BC                       ENDP 
0379 F0BC
0380 F0BC                       TITLE ', FILES.a - Read_Record'
0381 F0BC              *
0382 F0BC              ****************************************************************
0383 F0BC              *
0384 F0BC              *              Read next record from File Buffer
0385 F0BC              *
0386 F0BC              *  Inputs:     X - # of bytes
0387 F0BC              *
0388 F0BC              *  Outputs:    Record - updated
0389 F0BC              *              A - status if error
0390 F0BC              *              C - set if error occurred
0391 F0BC              *
0392 F0BC              *  Zero Page used: none
0393 F0BC              *
0394 F0BC              ****************************************************************
0395 F0BC              *
0396 F0BC
0397 F0BC              Read_Record PROC 
0398 F0BC                       with DirectPage, Globals
0399 F0BC
0400 F0BC F4 01 00              pea   Record>>16
0401 F0BF F4 04 A7              pea   |Record
0402 F0C2 F4 00 00              pea   0
0403 F0C5 DA                    phx   
0404 F0C6 20 D2 EF              jsr   Read_File
0405 F0C9 60                    rts   
0406 F0CA
0407 F0CA                       ENDP 
0408 F0CA
0409 F0CA                       TITLE ', FILES.a - Skip_Header'
0410 F0CA              *
0411 F0CA              ****************************************************************
0412 F0CA              *
0413 F0CA              *              Skip Next Segment Header
0414 F0CA              *
0415 F0CA              *  Inputs:     Header_Mark - Segment Header File Mark
0416 F0CA              *
0417 F0CA              *  Outputs:    A - status
0418 F0CA              *              C - set if error occurred
0419 F0CA              *              Header_Mark - File Mark of next Segment Header
0420 F0CA              *
0421 F0CA              *  Zero Page used: none
0422 F0CA              *
0423 F0CA              ****************************************************************
0424 F0CA              *
0425 F0CA
0426 F0CA              Skip_Header PROC 
0427 F0CA                       with DirectPage, Globals
0428 F0CA              ;
0429 F0CA              ;        set Mark of file to input Mark
0430 F0CA              ;
0431 F0CA AD 22 A7              lda   |Header_Mark
0432 F0CD 8D 62 A7              sta   |PSetMark.position
0433 F0D0 AD 24 A7              lda   |Header_Mark+2
0434 F0D3 8D 64 A7              sta   |PSetMark.position+2
0435 F0D6
0436 F0D6 22 A8 00 E1           jsl   $E100A8                  ;call GS/OS
0437 F0DA 16 00                 DC W:SET_MARK
0438 F0DC 60 A7 01 00           DC L:PSetMark
0439 F0E0 B0 2B                 bcs   error
0440 F0E2              ;
0441 F0E2              ;        read part of next Segment Header (enough to see BYTECNT and VERSION)
0442 F0E2              ;
0443 F0E2 A9 B8 A6              lda   #<Header
0444 F0E5 8D 4E A7              sta   |PRead.dataBuffer        ;set read address
0445 F0E8 A9 01 00              lda   #^Header
0446 F0EB 8D 50 A7              sta   |PRead.dataBuffer+2
0447 F0EE A9 15 00              lda   #SegmentHeader.Kind+1
0448 F0F1 8D 52 A7              sta   |PRead.requestCount      ;read enough bytes
0449 F0F4 A9 00 00              lda   #^SegmentHeader.Kind+1
0450 F0F7 8D 54 A7              sta   |PRead.requestCount+2
0451 F0FA
0452 F0FA 22 A8 00 E1           jsl   $E100A8
0453 F0FE 12 00                 DC W:PD_READ
0454 F100 4C A7 01 00           DC L:PRead
0455 F104 B0 07                 bcs   error
0456 F106              ;
0457 F106              ;        bump Header_Mark to next Header
0458 F106              ;
0459 F106 20 7C F4     cont     jsr   Bump_Mark
0460 F109
0461 F109 A9 00 00     return   lda   #0
0462 F10C 18                    clc   
0463 F10D 60           error    rts   
0464 F10E
0465 F10E                       ENDP 
0466 F10E
0467 F10E                       TITLE ', FILES.a - Next_Dictionary'
0468 F10E              *
0469 F10E              ****************************************************************
0470 F10E              *
0471 F10E              *        Position File to Relocation Dictionary of current Segment
0472 F10E              *
0473 F10E              *  Inputs:     Current offset into Mark List       (TOS+3)
0474 F10E              *
0475 F10E              *  Outputs:    Next offset into Mark List          (TOS+7)
0476 F10E              *              CSegNum - Segment Number in Mark List
0477 F10E              *                      - 0 if no more entries
0478 F10E              *              A - status
0479 F10E              *              C - set if error occurred
0480 F10E              *
0481 F10E              *  Zero Page used: TempZero
0482 F10E              *
0483 F10E              ****************************************************************
0484 F10E              *
0485 F10E
0486 F10E              Next_Dictionary PROC 
0487 F10E                       with DirectPage, Globals
0488 F10E
0489 F10E              IOffset  equ   3                        ;input  Offset
0490 F10E              OOffset  equ   7                        ;output Offset
0491 F10E              ;
0492 F10E              ;        if input Offset points to last entry in Mark List,
0493 F10E              ;        set CSegNum to 0 and return
0494 F10E              ;
0495 F10E              ;        last entry if output offset = Next Available Slot
0496 F10E              ;
0497 F10E 64 22                 stz   CSegNum
0498 F110 A3 03                 lda   IOffset,s
0499 F112 C7 30                 cmp   [MarkList]
0500 F114 D0 09                 bne   cont1
0501 F116 A3 05                 lda   IOffset+2,s
0502 F118 A0 02 00              ldy   #2
0503 F11B D7 30                 cmp   [MarkList],y
0504 F11D F0 60                 beq   return
0505 F11F              ;
0506 F11F              ;        calculate address of entry in Mark List
0507 F11F              ;
0508 F11F A3 03        cont1    lda   IOffset,s
0509 F121 18                    clc   
0510 F122 65 30                 adc   MarkList
0511 F124 85 00                 sta   TempZero
0512 F126 A3 05                 lda   IOffset+2,s
0513 F128 65 32                 adc   MarkList+2
0514 F12A 85 02                 sta   TempZero+2
0515 F12C              ;
0516 F12C              ;        extract Mark and store in ProDOS SetMark packet
0517 F12C              ;
0518 F12C A0 02 00              ldy   #2
0519 F12F B7 00                 lda   [TempZero],y
0520 F131 8D 62 A7              sta   |PSetMark.position
0521 F134 A0 04 00              ldy   #4
0522 F137 B7 00                 lda   [TempZero],y
0523 F139 8D 64 A7              sta   |PSetMark.position+2
0524 F13C              ;
0525 F13C              ;        is Mark in current File Buffer ?
0526 F13C              ;
0527 F13C AD 62 A7              lda   |PSetMark.position
0528 F13F 38                    sec   
0529 F140 ED 1E A7              sbc   |File_Mark
0530 F143 85 04                 sta   TempZero+4
0531 F145 AD 64 A7              lda   |PSetMark.position+2
0532 F148 ED 20 A7              sbc   |File_Mark+2
0533 F14B 85 06                 sta   TempZero+6
0534 F14D D0 0C                 bne   cont2
0535 F14F A5 04                 lda   TempZero+4
0536 F151 CD 1C A7              cmp   |File_EOB
0537 F154 B0 05                 bcs   cont2
0538 F156              ;
0539 F156              ;        yes, set File_Pt to location in File Buffer where Mark is
0540 F156              ;
0541 F156 8D 1A A7              sta   |File_Pt
0542 F159 80 11                 bra   cont3
0543 F15B              ;
0544 F15B              ;        no, set File Mark
0545 F15B              ;
0546 F15B 22 A8 00 E1  cont2    jsl   $E100A8                  ;call GS/OS
0547 F15F 16 00                 DC W:SET_MARK
0548 F161 60 A7 01 00           DC L:PSetMark
0549 F165 B0 1B                 bcs   error
0550 F167              ;
0551 F167              ;        fill File Buffer
0552 F167              ;
0553 F167 20 3C F3              jsr   Fill_File_Buff
0554 F16A B0 16                 bcs   error
0555 F16C              ;
0556 F16C              ;        set output offset = input offset + ML_SizeEntry
0557 F16C              ;
0558 F16C A3 03        cont3    lda   IOffset,s
0559 F16E 18                    clc   
0560 F16F 69 06 00              adc   #ML_SizeEntry
0561 F172 83 07                 sta   OOffset,s
0562 F174 A3 05                 lda   IOffset+2,s
0563 F176 69 00 00              adc   #0
0564 F179 83 09                 sta   OOffset+2,s
0565 F17B              ;
0566 F17B              ;        set CSegNum to SegNum in entry
0567 F17B              ;
0568 F17B A7 00                 lda   [TempZero]
0569 F17D 85 22                 sta   CSegNum
0570 F17F
0571 F17F A9 00 00     return   lda   #0
0572 F182 A8 68 83 03  error    Stack_Cleanup 4
0573 F18C                       rts   
0574 F18C
0575 F18C                       ENDP 
0576 F18C
0577 F18C                       TITLE ', FILES.a - Setup_Buf_Ptrs'
0578 F18C              *
0579 F18C              ****************************************************************
0580 F18C              *
0581 F18C              *              Setup buffer pointers
0582 F18C              *
0583 F18C              ****************************************************************
0584 F18C              *
0585 F18C              Setup_Buf_Ptrs Proc 
0586 F18C                       with DirectPage, Globals
0587 F18C
0588 F18C                       Entry zero_marks
0589 F18C              ;
0590 F18C              ;       check amount of memory on system
0591 F18C              ;
0592 F18C 48                    pha   
0593 F18D 48                    pha   
0594 F18E A2 02 1D 22           _TotalMem 
0595 F195 68                    pla   
0596 F196 FA                    plx   
0597 F197              ;
0598 F197              ;       if a minimal system (512K), use an 8K buffer, otherwise use 16K
0599 F197              ;
0600 F197 A9 00 40              lda   #$4000
0601 F19A E0 08 00              cpx   #8
0602 F19D D0 03                 bne   @cont1
0603 F19F A9 00 20              lda   #$2000
0604 F1A2              ;
0605 F1A2              ;       set File Buffer size
0606 F1A2              ;
0607 F1A2 8D 18 A7     @cont1   sta   |File_Buff_Size
0608 F1A5              ;
0609 F1A5              ;        allocate a File Buffer
0610 F1A5              ;
0611 F1A5 A2 00 00              ldx   #0
0612 F1A8 DA                    phx                            ;output Handle
0613 F1A9 DA                    phx   
0614 F1AA DA                    phx   
0615 F1AB 48                    pha                            ;BlockSize (size still in Accumulator)
0616 F1AC F4 06 70              pea   uFileBuff                ;Owner
0617 F1AF F4 00 80              pea   attrLocked               ;Attributes
0618 F1B2 DA                    phx                            ;Location
0619 F1B3 DA                    phx   
0620 F1B4
0621 F1B4 A2 02 09 22           _NewHandle 
0622 F1BB FA                    plx                            ;output Handle
0623 F1BC 7A                    ply   
0624 F1BD B0 24                 bcs   error
0625 F1BF
0626 F1BF 8A                    txa   
0627 F1C0 20 D6 FA              jsr   DeRef                    ;dereference Handle
0628 F1C3 8D 14 A7              sta   |File_Buff               ;save address in Globals
0629 F1C6 8C 16 A7              sty   |File_Buff+2
0630 F1C9 85 28                 sta   FileBuff                 ;save address in Zero Page
0631 F1CB 84 2A                 sty   FileBuff+2
0632 F1CD              ;
0633 F1CD              ;        initialize File variables
0634 F1CD              ;
0635 F1CD 9C 1C A7              stz   |File_EOB                ;File Buffer EOB
0636 F1D0              zero_marks  
0637 F1D0 9C 1E A7              stz   |File_Mark               ;File Mark
0638 F1D3 9C 20 A7              stz   |File_Mark+2
0639 F1D6 9C 22 A7              stz   |Header_Mark             ;Segment Header File Mark
0640 F1D9 9C 24 A7              stz   |Header_Mark+2
0641 F1DC 9C 1A A7              stz   |File_Pt                 ;File Buffer Pointer
0642 F1DF              ;
0643 F1DF              ;        initialize Mark List
0644 F1DF              ;
0645 F1DF 64 30                 stz   MarkList
0646 F1E1 64 32                 stz   MarkList+2
0647 F1E3              error     
0648 F1E3 60                    rts   
0649 F1E4
0650 F1E4                       EndP 
0651 F1E4
0652 F1E4                       TITLE ', FILES.a - Open_File'
0653 F1E4              *
0654 F1E4              ****************************************************************
0655 F1E4              *
0656 F1E4              *              Open File
0657 F1E4              *
0658 F1E4              *  Inputs:      Address of Pathname (TOS+11)    - must be type 1 string
0659 F1E4              *               Time/Date Stamp     (TOS+3)
0660 F1E4              *
0661 F1E4              *  Outputs:    A - status code
0662 F1E4              *              C - set if error
0663 F1E4              *
0664 F1E4              *  Zero Page used: TempZero
0665 F1E4              *
0666 F1E4              ****************************************************************
0667 F1E4              *
0668 F1E4
0669 F1E4              Open_File PROC 
0670 F1E4                       with DirectPage, Globals
0671 F1E4
0672 F1E4              Pathname equ   11
0673 F1E4              Date     equ   3
0674 F1E4              ;
0675 F1E4              ;       zero refnum in Open packet
0676 F1E4              ;
0677 F1E4 9C 28 A7              stz   |POpen.refNum
0678 F1E7              ;
0679 F1E7              ;        check if Memory Load requested
0680 F1E7              ;
0681 F1E7 A5 38                 lda   Memory_Load
0682 F1E9 F0 2A                 beq   cont2
0683 F1EB              ;
0684 F1EB              ;        yes, set File Buffer variables to contents of packet.  In essence,
0685 F1EB              ;        the File in memory will act as the Loader's File Buffer
0686 F1EB              ;
0687 F1EB A3 0B                 lda   Pathname,s
0688 F1ED 85 00                 sta   TempZero
0689 F1EF A3 0D                 lda   Pathname+2,s
0690 F1F1 85 02                 sta   TempZero+2
0691 F1F3 A7 00                 lda   [TempZero]
0692 F1F5 8D 14 A7              sta   |File_Buff
0693 F1F8 85 28                 sta   FileBuff
0694 F1FA A0 02 00              ldy   #2
0695 F1FD B7 00                 lda   [TempZero],y
0696 F1FF 8D 16 A7              sta   |File_Buff+2
0697 F202 85 2A                 sta   FileBuff+2
0698 F204 A0 04 00              ldy   #4
0699 F207 B7 00                 lda   [TempZero],y
0700 F209 8D 18 A7              sta   |File_Buff_Size
0701 F20C 8D 1C A7              sta   |File_EOB
0702 F20F 20 D0 F1              jsr   zero_marks
0703 F212 4C FC F2              jmp   normal_exit
0704 F215              ;
0705 F215              ;       see if file is already opened by getting its refnum from GS/OS
0706 F215              ;
0707 F215 A9 02 00     cont2    lda   #2
0708 F218 8D 82 A7              sta   |PGetRefNum.pCount       ;parameter count
0709 F21B A3 0B                 lda   Pathname,s
0710 F21D 8D 84 A7              sta   |PGetRefNum.pathname     ;pathname
0711 F220 A3 0D                 lda   Pathname+2,s
0712 F222 8D 86 A7              sta   |PGetRefNum.pathname+2
0713 F225 22 A8 00 E1           jsl   $E100A8
0714 F229 38 20                 DC W:GetRefNum
0715 F22B 82 A7 01 00           DC L:PGetRefNum
0716 F22F B0 09                 bcs   cont3
0717 F231              ;
0718 F231              ;       file is already open, so put its refnum into the Open packet and skip open
0719 F231              ;
0720 F231 AD 88 A7              lda   |PGetRefNum.refNum
0721 F234 8D 28 A7              sta   |POpen.refNum
0722 F237 4C D9 F2              jmp   cont7
0723 F23A              ;
0724 F23A              ;        setup Open packet
0725 F23A              ;
0726 F23A A9 0A 00     cont3    lda   #10
0727 F23D 8D 26 A7              sta   |POpen.pCount            ;parameter count
0728 F240 A3 0B                 lda   Pathname,s
0729 F242 8D 2A A7              sta   |POpen.pathname          ;pathname
0730 F245 A3 0D                 lda   Pathname+2,s
0731 F247 8D 2C A7              sta   |POpen.pathname+2
0732 F24A A9 01 00              lda   #1
0733 F24D 8D 2E A7              sta   |POpen.requestAccess     ;access code (read_only)
0734 F250 9C 30 A7              stz   |POpen.resourceNumber    ;resource number
0735 F253              ;
0736 F253              ;       get system file level
0737 F253              ;
0738 F253 A9 02 00              lda   #2
0739 F256 8D 76 A7              sta   |PGetLevel.pCount        ;parameter count
0740 F259 9C 7A A7              stz   |PGetLevel.levelMode     ;mode
0741 F25C 22 A8 00 E1           jsl   $E100A8
0742 F260 1B 20                 DC W:GetLevel
0743 F262 76 A7 01 00           DC L:PGetLevel
0744 F266              ;
0745 F266              ;       set system file level to $70
0746 F266              ;
0747 F266 A9 02 00              lda   #2
0748 F269 8D 7C A7              sta   |PSetLevel.pCount        ;parameter count
0749 F26C A9 70 00              lda   #$70
0750 F26F 8D 7E A7              sta   |PSetLevel.level         ;system file level
0751 F272 9C 80 A7              stz   |PSetLevel.levelMode     ;mode
0752 F275 22 A8 00 E1           jsl   $E100A8
0753 F279 1A 20                 DC W:SetLevel
0754 F27B 7C A7 01 00           DC L:PSetLevel
0755 F27F              ;
0756 F27F              ;        open file
0757 F27F              ;
0758 F27F 22 A8 00 E1           jsl   $E100A8
0759 F283 10 20                 DC W:Open
0760 F285 26 A7 01 00           DC L:POpen
0761 F289 08                    php                            ;save status
0762 F28A 48                    pha   
0763 F28B              ;
0764 F28B              ;       restore system file level to its original value
0765 F28B              ;
0766 F28B AD 78 A7              lda   |PGetLevel.level
0767 F28E 8D 7E A7              sta   |PSetLevel.level         ;system file level
0768 F291 22 A8 00 E1           jsl   $E100A8
0769 F295 1A 20                 DC W:SetLevel
0770 F297 7C A7 01 00           DC L:PSetLevel
0771 F29B              ;
0772 F29B              ;       check open status
0773 F29B              ;
0774 F29B 68                    pla   
0775 F29C 28                    plp   
0776 F29D B0 60                 bcs   error
0777 F29F              ;
0778 F29F              ;        check file type
0779 F29F              ;
0780 F29F AD 34 A7              lda   |POpen.fileType          ;get file_type
0781 F2A2 C9 B3 00              cmp   #Load_File               ;is it in range of Load File types?
0782 F2A5 90 0A                 bcc   cont4
0783 F2A7 C9 BF 00              cmp   #Last_Load_File+1
0784 F2AA 90 0A                 bcc   cont5
0785 F2AC C9 C7 00              cmp   #CDev_File               ;is it a CDev?
0786 F2AF F0 05                 beq   cont5                    ;yes, we can load it.
0787 F2B1              ;
0788 F2B1              ;        Not Load File error
0789 F2B1              ;
0790 F2B1 A9 04 11     cont4    lda   #NotLoad
0791 F2B4 80 49                 bra   error
0792 F2B6              ;
0793 F2B6              ;        compare input time/date stamp (if not zero) with file's
0794 F2B6              ;
0795 F2B6 A3 03        cont5    lda   Date,s
0796 F2B8 F0 1F                 beq   cont7
0797 F2BA CD 44 A7              cmp   |POpen.modDateTime
0798 F2BD D0 15                 bne   cont6
0799 F2BF A3 05                 lda   Date+2,s
0800 F2C1 CD 46 A7              cmp   |POpen.modDateTime+2
0801 F2C4 D0 0E                 bne   cont6
0802 F2C6 A3 07                 lda   Date+4,s
0803 F2C8 CD 48 A7              cmp   |POpen.modDateTime+4
0804 F2CB D0 07                 bne   cont6
0805 F2CD A3 09                 lda   Date+6,s
0806 F2CF CD 4A A7              cmp   |POpen.modDateTime+6
0807 F2D2 F0 05                 beq   cont7
0808 F2D4              ;
0809 F2D4              ;        time/date stamps do not compare - Bad Version error
0810 F2D4              ;
0811 F2D4 A9 07 11     cont6    lda   #BadVers
0812 F2D7              error_skip  
0813 F2D7 80 26                 bra   error
0814 F2D9              ;
0815 F2D9              ;        move ref_num to other ProDOS packets
0816 F2D9              ;
0817 F2D9 AD 28 A7     cont7    lda   |POpen.refNum
0818 F2DC 8D 4C A7              sta   |PRead.fileRefNum
0819 F2DF 8D 5A A7              sta   |PGetMark.markRefNum
0820 F2E2 8D 60 A7              sta   |PSetMark.markRefNum
0821 F2E5
0822 F2E5 22 A8 00 E1           jsl   $E100A8                  ;get the file's EOF
0823 F2E9 19 00                 DC W:GET_EOF
0824 F2EB 5A A7 01 00           DC L:PGetMark                  ;borrow this parameter block
0825 F2EF
0826 F2EF AD 5C A7              lda   PGetMark.position        ;is there anything in the file?
0827 F2F2 0D 5E A7              ora   PGetMark.position+2
0828 F2F5 F0 BA                 beq   cont4                    ;no, can't be a load file
0829 F2F7
0830 F2F7 20 8C F1              jsr   Setup_Buf_Ptrs
0831 F2FA B0 03                 bcs   error
0832 F2FC
0833 F2FC              normal_exit  
0834 F2FC A9 00 00              lda   #0                       ;set status to OK
0835 F2FF A8 68 83 0B  error    Stack_Cleanup 12               ;remove input parameters
0836 F30D 60                    rts                            ;return
0837 F30E
0838 F30E                       ENDP 
0839 F30E
0840 F30E                       TITLE ', FILES.a - Close_File'
0841 F30E              *
0842 F30E              ****************************************************************
0843 F30E              *
0844 F30E              *              Close File
0845 F30E              *
0846 F30E              *  Inputs:      none
0847 F30E              *
0848 F30E              *  Outputs:     A - status code
0849 F30E              *               C - set if error
0850 F30E              *
0851 F30E              *  Zero Page used: none
0852 F30E              *
0853 F30E              *           If Keep_Open is true, the file is not really closed
0854 F30E              *
0855 F30E              ****************************************************************
0856 F30E              *
0857 F30E
0858 F30E              Close_File PROC 
0859 F30E                       with DirectPage, Globals
0860 F30E
0861 F30E              ;
0862 F30E              ;        if Memory_Load is set, only dispose of the buffers
0863 F30E              ;
0864 F30E A5 38                 lda   Memory_Load
0865 F310 D0 1A                 bne   cont1
0866 F312              ;
0867 F312              ;        if RefNum is zero, don't issue close
0868 F312              ;
0869 F312 AD 28 A7              lda   |POpen.refNum
0870 F315 F0 15                 beq   cont1
0871 F317              ;
0872 F317              ;        if Keep_Open is true,  don't issue close
0873 F317              ;
0874 F317 A5 3A                 lda   Keep_Open
0875 F319 D0 11                 bne   cont1
0876 F31B              ;
0877 F31B              ;        close file
0878 F31B              ;
0879 F31B AD 28 A7              lda   POpen.refNum             ;do we have a valid refnum?
0880 F31E F0 0C                 beq   cont1                    ;no, so don't do a global close!
0881 F320
0882 F320 22 A8 00 E1           jsl   $E100A8
0883 F324 14 00                 DC W:PD_CLOSE
0884 F326 28 A7 01 00           DC L:POpen.refNum
0885 F32A B0 0A                 bcs   error
0886 F32C              ;
0887 F32C              ;        dispose of File Buffers
0888 F32C              ;
0889 F32C F4 06 70     cont1    pea   uFileBuff                ;Owner
0890 F32F
0891 F32F A2 02 11 22           _DisposeAll 
0892 F336
0893 F336 9C 28 A7     error    stz   |POpen.refNum            ;zero refnum
0894 F339 64 B4                 stz   file_open                ;zero flag
0895 F33B 60                    rts                            ;return
0896 F33C
0897 F33C                       ENDP 
0898 F33C
0899 F33C                       TITLE ', FILES.a - Fill_File_Buff'
0900 F33C              *
0901 F33C              ****************************************************************
0902 F33C              *
0903 F33C              *              Refill File Buffer
0904 F33C              *
0905 F33C              *  Inputs:     none
0906 F33C              *
0907 F33C              *  Outputs:    A - status
0908 F33C              *              C - set if error occurred
0909 F33C              *
0910 F33C              *  Zero Page used: none
0911 F33C              *
0912 F33C              ****************************************************************
0913 F33C              *
0914 F33C
0915 F33C              Fill_File_Buff PROC 
0916 F33C                       with DirectPage, Globals
0917 F33C              ;
0918 F33C              ;        set File_Mark to current File Mark
0919 F33C              ;
0920 F33C 22 A8 00 E1           jsl   $E100A8
0921 F340 17 00                 DC W:GET_MARK
0922 F342 5A A7 01 00           DC L:PGetMark
0923 F346 B0 39                 bcs   error
0924 F348
0925 F348 AD 5C A7              lda   |PGetMark.position
0926 F34B 8D 1E A7              sta   |File_Mark
0927 F34E AD 5E A7              lda   |PGetMark.position+2
0928 F351 8D 20 A7              sta   |File_Mark+2
0929 F354              ;
0930 F354              ;        fill buffer by reading file
0931 F354              ;
0932 F354 AD 14 A7              lda   |File_Buff
0933 F357 8D 4E A7              sta   |PRead.dataBuffer        ;buffer address
0934 F35A AD 16 A7              lda   |File_Buff+2
0935 F35D 8D 50 A7              sta   |PRead.dataBuffer+2
0936 F360 AD 18 A7              lda   |File_Buff_Size
0937 F363 8D 52 A7              sta   |PRead.requestCount      ;# of bytes to read
0938 F366 9C 54 A7              stz   |PRead.requestCount+2
0939 F369
0940 F369 22 A8 00 E1           jsl   $E100A8
0941 F36D 12 00                 DC W:PD_READ
0942 F36F 4C A7 01 00           DC L:PRead
0943 F373 B0 0C                 bcs   error
0944 F375              ;
0945 F375              ;        set File_Pt and File_EOB
0946 F375              ;
0947 F375 AD 56 A7              lda   |PRead.transferCount
0948 F378 8D 1C A7              sta   |File_EOB                ;# of bytes actually read
0949 F37B 9C 1A A7              stz   |File_Pt                 ;zero File Pointer
0950 F37E A9 00 00              lda   #0                       ;carry already clear
0951 F381 60           error    rts   
0952 F382
0953 F382                       ENDP 
0954 F382
0955 F382                       TITLE ', FILES.a - Save_Mark'
0956 F382              *
0957 F382              ****************************************************************
0958 F382              *
0959 F382              *              Save OP Mark in Mark List
0960 F382              *
0961 F382              *  Inputs:     OP_Mark - File Mark of current OP code
0962 F382              *              CSegNum - current Segment Number
0963 F382              *
0964 F382              *  Outputs:    Mark List updated
0965 F382              *              A - status
0966 F382              *              C - set if error occurred
0967 F382              *
0968 F382              *  Zero Page used: TempZero, Handle
0969 F382              *
0970 F382              ****************************************************************
0971 F382              *
0972 F382
0973 F382              Save_Mark PROC 
0974 F382                       with DirectPage
0975 F382
0976 F382              Size_Header equ   ML_FirstEntry         ;# of bytes in List header
0977 F382              Size_Incr equ   100                     ;# of entries in each expansion
0978 F382              ;
0979 F382              ;        if the address of the Mark List=0, create a new one
0980 F382              ;
0981 F382 A5 30                 lda   MarkList
0982 F384 05 32                 ora   MarkList+2
0983 F386 D0 43                 bne   cont1
0984 F388
0985 F388 A2 00 00              ldx   #0                       ;output Handle
0986 F38B DA                    phx   
0987 F38C DA                    phx   
0988 F38D F4 00 00              pea   ML_SizeEntry*Size_Incr+Size_Header>>16  ;BlockSize
0989 F390 F4 60 02              pea   |ML_SizeEntry*Size_Incr+Size_Header
0990 F393 F4 07 70              pea   uMarkList                ;Owner
0991 F396 F4 08 80              pea   attrLocked+attrNoSpec    ;Attributes
0992 F399 DA                    phx                            ;Location
0993 F39A DA                    phx   
0994 F39B
0995 F39B A2 02 09 22           _NewHandle 
0996 F3A2 FA                    plx                            ;output Handle
0997 F3A3 7A                    ply   
0998 F3A4 90 03                 bcc   @1
0999 F3A6 4C 7B F4              jmp   error
1000 F3A9              @1        
1001 F3A9 8A                    txa   
1002 F3AA 20 D6 FA              jsr   DeRef                    ;dereference Handle
1003 F3AD 85 30                 sta   MarkList                 ;save address in Zero Page
1004 F3AF 84 32                 sty   MarkList+2
1005 F3B1              ;
1006 F3B1              ;        set Next Available Slot to Size_Header and set End of List to
1007 F3B1              ;        ML_SizeEntry*Size_Incr+Size_Header
1008 F3B1              ;
1009 F3B1 A9 08 00              lda   #Size_Header
1010 F3B4 87 30                 sta   [MarkList]
1011 F3B6 A9 60 02              lda   #ML_SizeEntry*Size_Incr+Size_Header
1012 F3B9 A0 04 00              ldy   #4
1013 F3BC 97 30                 sta   [MarkList],y
1014 F3BE A9 00 00              lda   #0
1015 F3C1 A0 02 00              ldy   #2
1016 F3C4 97 30                 sta   [MarkList],y
1017 F3C6 A0 06 00              ldy   #6
1018 F3C9 97 30                 sta   [MarkList],y
1019 F3CB              ;
1020 F3CB              ;        is there any more room in Mark List ?
1021 F3CB              ;        (if Next Available Slot = End of List then List is full)
1022 F3CB              ;
1023 F3CB A7 30        cont1    lda   [MarkList]               ;Next Available Slot
1024 F3CD A0 04 00              ldy   #4
1025 F3D0 D7 30                 cmp   [MarkList],y             ;End of List
1026 F3D2 D0 6F                 bne   cont3
1027 F3D4 A0 02 00              ldy   #2
1028 F3D7 B7 30                 lda   [MarkList],y
1029 F3D9 A0 06 00              ldy   #6
1030 F3DC D7 30                 cmp   [MarkList],y
1031 F3DE D0 63                 bne   cont3
1032 F3E0              ;
1033 F3E0              ;        no more room, get handle to Mark List
1034 F3E0              ;
1035 F3E0 D4 32        cont2    pei   MarkList+2               ;address of Mark List
1036 F3E2 D4 30                 pei   MarkList
1037 F3E4 A2 02 1A 22           _FindHandle 
1038 F3EB A3 01                 lda   1,s
1039 F3ED 85 08                 sta   Handle                   ;retrieve handle
1040 F3EF A3 03                 lda   3,s                      ;but leave on stack for HUnlock call
1041 F3F1 85 0A                 sta   Handle+2
1042 F3F3              ;
1043 F3F3              ;        unlock Mark List
1044 F3F3              ;
1045 F3F3 A2 02 22 22           _HUnlock 
1046 F3FA              ;
1047 F3FA              ;        expand Mark List by another ML_SizeEntry*Size_Incr
1048 F3FA              ;
1049 F3FA A0 04 00              ldy   #4
1050 F3FD B7 30                 lda   [MarkList],y
1051 F3FF 18                    clc   
1052 F400 69 58 02              adc   #ML_SizeEntry*Size_Incr
1053 F403 85 00                 sta   TempZero
1054 F405 AA                    tax   
1055 F406 A0 06 00              ldy   #6
1056 F409 B7 30                 lda   [MarkList],y
1057 F40B 69 00 00              adc   #0
1058 F40E 85 02                 sta   TempZero+2
1059 F410
1060 F410 48                    pha   
1061 F411 DA                    phx                            ;Size
1062 F412 D4 0A                 pei   Handle+2                 ;Handle
1063 F414 D4 08                 pei   Handle
1064 F416 A2 02 19 22           _SetHandleSize 
1065 F41D B0 5C                 bcs   error
1066 F41F              ;
1067 F41F              ;        lock Mark List
1068 F41F              ;
1069 F41F D4 0A                 pei   Handle+2                 ;Handle
1070 F421 D4 08                 pei   Handle
1071 F423 A2 02 20 22           _HLock 
1072 F42A              ;
1073 F42A              ;        get new address of Mark List
1074 F42A              ;
1075 F42A A5 08                 lda   Handle
1076 F42C A4 0A                 ldy   Handle+2
1077 F42E 20 D6 FA              jsr   DeRef                    ;dereference Handle
1078 F431 85 30                 sta   MarkList
1079 F433 84 32                 sty   MarkList+2
1080 F435              ;
1081 F435              ;        set End of List to new value
1082 F435              ;
1083 F435 A5 00                 lda   TempZero
1084 F437 A0 04 00              ldy   #4
1085 F43A 97 30                 sta   [MarkList],y
1086 F43C A5 02                 lda   TempZero+2
1087 F43E A0 06 00              ldy   #6
1088 F441 97 30                 sta   [MarkList],y
1089 F443              ;
1090 F443              ;        calculate address of Next Available Slot
1091 F443              ;
1092 F443 A5 30        cont3    lda   MarkList
1093 F445 18                    clc   
1094 F446 67 30                 adc   [MarkList]
1095 F448 85 00                 sta   TempZero
1096 F44A A5 32                 lda   MarkList+2
1097 F44C A0 02 00              ldy   #2
1098 F44F 77 30                 adc   [MarkList],y
1099 F451 85 02                 sta   TempZero+2
1100 F453              ;
1101 F453              ;        store Segment Number and Op_Mark in Next Available Slot
1102 F453              ;
1103 F453 A5 22                 lda   CSegNum
1104 F455 87 00                 sta   [TempZero]
1105 F457 A5 2C                 lda   Op_Mark
1106 F459 A0 02 00              ldy   #2
1107 F45C 97 00                 sta   [TempZero],y
1108 F45E A5 2E                 lda   Op_Mark+2
1109 F460 A0 04 00              ldy   #4
1110 F463 97 00                 sta   [TempZero],y
1111 F465              ;
1112 F465              ;        increment Next Available Slot by ML_SizeEntry
1113 F465              ;
1114 F465 A7 30                 lda   [MarkList]
1115 F467 18                    clc   
1116 F468 69 06 00              adc   #ML_SizeEntry
1117 F46B 87 30                 sta   [MarkList]
1118 F46D 90 08                 bcc   return
1119 F46F A0 02 00              ldy   #2
1120 F472 B7 30                 lda   [MarkList],y
1121 F474 1A                    inc   a
1122 F475 97 30                 sta   [MarkList],y
1123 F477
1124 F477 A9 00 00     return   lda   #0
1125 F47A 18                    clc   
1126 F47B 60           error    rts   
1127 F47C
1128 F47C                       ENDP 
1129 F47C
1130 F47C                       TITLE ', FILES.a - Bump_Mark'
1131 F47C              *
1132 F47C              ****************************************************************
1133 F47C              *
1134 F47C              *              Bump Header_Mark to next Header
1135 F47C              *
1136 F47C              *  Inputs:     Header - current Segment Header
1137 F47C              *              Header_Mark - File Mark of Segment Header
1138 F47C              *
1139 F47C              *  Outputs:    Header_Mark - File Mark of next Segment Header
1140 F47C              *
1141 F47C              *  Zero Page used: none
1142 F47C              *
1143 F47C              ****************************************************************
1144 F47C              *
1145 F47C
1146 F47C              Bump_Mark PROC 
1147 F47C                       with DirectPage, Globals
1148 F47C              ;
1149 F47C              ;        if Version<2, convert BYTECNT to bytes (*512)
1150 F47C              ;
1151 F47C AD C7 A6              lda   Header.Version
1152 F47F C9 02 00              cmp   #2
1153 F482 B0 10                 bcs   cont
1154 F484
1155 F484 A2 09 00              ldx   #9
1156 F487 AD B8 A6              lda   Header.ByteCnt
1157 F48A              @loop     
1158 F48A 0A                    asl   a
1159 F48B 2E BA A6              rol   Header.ByteCnt+2
1160 F48E CA                    dex   
1161 F48F D0 F9                 bne   @loop
1162 F491 8D B8 A6              sta   Header.ByteCnt
1163 F494              ;
1164 F494              ;        increment input Mark by BYTECNT to get output mark
1165 F494              ;
1166 F494 AD 22 A7     cont     lda   |Header_Mark
1167 F497 18                    clc   
1168 F498 6D B8 A6              adc   Header.ByteCnt
1169 F49B 8D 22 A7              sta   |Header_Mark
1170 F49E AD 24 A7              lda   |Header_Mark+2
1171 F4A1 6D BA A6              adc   Header.ByteCnt+2
1172 F4A4 8D 24 A7              sta   |Header_Mark+2
1173 F4A7
1174 F4A7 60                    rts   
1175 F4A8
1176 F4A8                       ENDP 
